<?php

namespace App\Moron\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Panel extends Model 
{

    protected $table = 'paneles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('codigo', 'nombre');
    protected $visible = array('codigo', 'nombre');

    public function tasas()
    {
        return $this->hasMany('App\Moron\Models\Tasa');
    }

    public function gastos()
    {
        return $this->hasMany('App\Moron\Models\Gasto');
    }

    public function info_comparativa()
    {
        return $this->hasMany('App\Moron\Models\Panel');
    }

}